/*
 * TagReadHandlerBase.h
 *
 *  Created on: 30.04.2010
 *      Author: stefan.detter
 */

#ifndef TAGREADHANDLERBASE_H_
#define TAGREADHANDLERBASE_H_

#include <QObject>

#include "../../application/event/TagEvent.h"


class Application;
class Reader;

class TagReadHandlerBase : public QObject
{
	Q_OBJECT

public:
	TagReadHandlerBase(QWidget* mainWidget, Application* manager, QObject* parent = 0);
	virtual ~TagReadHandlerBase();

public slots:
	virtual void handlingActivated ( bool on );

	void readerAttached ( Reader* reader );

	virtual void tagEvent(const TagEvent& event);

private:
	Application*			m_application;
	uint 					m_flags;

protected:
	QWidget* 				m_mainWidget;
	bool					m_handlingOn;
};

#endif /* TAGREADHANDLERBASE_H_ */
